from tkinter import * 
from serial import *
from VapourtecCommands import *
import multiprocessing as multip



def VapourtecStart(port1, minflow, maxflow, volume, pump, react, temp1, temp2, temp3, temp4, q1, q2 ,q3, q4):
	
	
	ser = serial.Serial(
		port = "COM" + port1,
		baudrate = 19200,
		parity = serial.PARITY_NONE,
		stopbits = serial.STOPBITS_ONE,
		bytesize = serial.EIGHTBITS,
		)

	
	min_react = volume / maxflow
	max_react = volume / minflow

	pumptest = pump
	PumpAcheck, PumpBcheck, PumpCcheck, PumpDcheck = pumptest.split('.')
	
	reacttest = react
	react1, react2, react3, react4 = reacttest.split('.')


	runwindow = Toplevel(root)
	runwindow.grab_set()
	T = Text(runwindow)
	T.grid(row = 0, column = 0)
	T.insert(END, "Minimum reaction time: " + str(min_react) + " mins\n")
	T.insert(END, "Maximum reaction time: " + str(max_react) + " mins\n")
	tempready = 0
	
	TempCheck(ser, q1, q2, q3, q4)
	temp1actual = q1.get()
	temp2actual = q2.get()
	temp3actual = q3.get()
	temp4actual = q4.get()
	
	if react1 == 0:
		temp1 = temp1actual
		Vtec_ReactorA(ser,temp1)
	else:
		Vtec_ReactorA(ser,temp1)
		
	if react2 == 0:
		temp2 = temp2actual
		Vtec_ReactorB(ser,temp2)
	else:
		Vtec_ReactorB(ser,temp2)
			
	if react3 == 0:
		temp3 = temp3actual
		Vtec_ReactorC(ser,temp3)
	else:
		Vtec_ReactorC(ser,temp3)
			
	if react4 == 0:
		temp4 = temp4actual
		Vtec_ReactorD(ser,temp4)
	else:
		Vtec_ReactorD(ser,temp4)
		
	Vtec_PumpA(ser,0)
	Vtec_PumpB(ser,0)
	Vtec_PumpC(ser,0)
	Vtec_PumpD(ser,0)
	Vtec_On(ser)
	
	
	while tempready == 0:
		TempCheck(ser, q1, q2, q3, q4)
		temp1actual = q1.get()
		temp2actual = q2.get()
		temp3actual = q3.get()
		temp4actual = q4.get()
	
		if temp1 == temp1actual and temp2 == temp2actual and temp3 == temp3actual and temp4 == temp4actual:
			tempready = 1
		
		
		else:
			TempCheck(ser, q1, q2, q3, q4)
			temp1actual = int(q1.get())
			temp2actual = int(q2.get())
			temp3actual = int(q3.get())
			temp4actual = int(q4.get())
			
	number_ofpumps = pumptest.count('1')
	
	average_maxflow = maxflow/number_ofpumps
	average_minflow = minflow/number_ofpumps
	
	if pumpAcheck == 0:
		Vtec_PumpA(ser,0)
	else:
		Vtec_PumpA(ser,average_minflow)
	if pumpBcheck == 0:
		Vtec_PumpB(ser,0)
	else:
		Vtec_PumpB(ser,average_minflow)
	if pumpCcheck == 0:
		Vtec_PumpC(ser,0)
	else:
		Vtec_PumpC(ser,average_minflow)
	if pumpDcheck == 0:
		Vtec_PumpD(ser,0)
	else:
		Vtec_PumpD(ser,average_minflow)
		
	Vtec_On(ser)
	
	time.sleep((max_react*2.5)*60)
	
	Vtec_PumpA(ser,average_maxflow)
	Vtec_PumpB(ser,average_maxflow)
	Vtec_PumpC(ser,average_maxflow)
	Vtec_PumpD(ser,average_maxflow)
	
	time.sleep((min_react*2.5)*60)
	Vtec_Off(ser)
	
def TempCheck(port, q1, q2, q3, q4):
		TempGet(port)
		Raw_Temp = port.read(36)
		Temp_list = str(Raw_Temp).split(',U,')
		Temp1 = Temp_list[1]
		Temp2 = Temp_list[2]
		Temp3 = Temp_list[3]
		Temp4 = Temp_list[4] [:3]
		q1.put(Temp1)
		q2.put(Temp2)
		q3.put(Temp3)
		q4.put(Temp4)




class window2(object):
	def __init__(self, master1):
		
		
		def react_1_check():
			if reactorA.get() == 1:	
				reactor1_button.deselect()
				reactor1_temp.configure(state = 'normal')
				reactor1_label.configure(state = 'normal')
			elif reactorA.get() == 0:
				reactor1_button.select()
				reactor1_temp.configure(state = 'disabled')
				reactor1_label.configure(state = 'disabled')

		def react_2_check():
			if reactorB.get() == 1:	
				reactor2_button.deselect()
				reactor2_temp.configure(state = 'normal')
				reactor2_label.configure(state = 'normal')
			elif reactorB.get() == 0:
				reactor2_button.select()
				reactor2_temp.configure(state = 'disabled')
				reactor2_label.configure(state = 'disabled')
				
		def react_3_check():
			if reactorC.get() == 1:	
				reactor3_button.deselect()
				reactor3_temp.configure(state = 'normal')
				reactor3_label.configure(state = 'normal')
			elif reactorC.get() == 0:
				reactor3_button.select()
				reactor3_temp.configure(state = 'disabled')
				reactor3_label.configure(state = 'disabled')
					
		def react_4_check():
			if reactorD.get() == 1:	
				reactor4_button.deselect()
				reactor4_temp.configure(state = 'normal')
				reactor4_label.configure(state = 'normal')
			elif reactorD.get() == 0:
				reactot4_button.select()
				reactor4_temp.configure(state = 'disabled')
				reactor4_label.configure(state = 'disabled')
			
				
		def check_input():
			reactor1_button.select()
			reactor2_button.select()
			reactor3_button.select()
			reactor4_button.select()
				
			#minimum flow rate check
			try:
				if 0.09 < float(min_flow.get()) < 10:
					min_check_button.select()
					min_flow_error.grid_forget()
				
				else:
					min_flow_error.grid(row = 0, column = 2)
					min_check_button.deselect()
			except ValueError:
					min_flow_error.grid(row = 0, column = 2)
					min_check_button.deselect()
						
			#maximum flow rate check
			try:
				if 0.09 < float(max_flow.get()) < 10 and float(max_flow.get()) > float(min_flow.get()):
					max_flow_error.grid_forget()
					max_check_button.select()
					
				elif 0.09 > float(max_flow.get()):
					max_flow_error.configure(text = "Flow rate must be between 0.1 and 9.99 mL/min")
					max_flow_error.grid(row = 1, column = 2)
					max_check_button.deselect()
						
				elif 9.99 < float(max_flow.get()):
					max_flow_error.configure(text = "Flow rate must be between 0.1 and 9.99 mL/min")
					max_flow_error.grid(row = 1, column = 2)
					max_check_button.deselect()
						
				elif float(max_flow.get()) <= float(min_flow.get()):
					max_flow_error.configure(text = "Maximum flow rate must be above minimum flow rate")
					max_flow_error.grid(row = 1, column = 2)
					max_check_button.deselect()
			except ValueError:
					max_flow_error.configure(text = "Flow rate must be between 0.1 and 9.99 mL/min")
					max_flow_error.grid(row = 1, column = 2)
					max_check_button.deselect()
						
			#volume check		
			try:
				if 0 >= float(vol_.get()):
					vol_error.grid(row = 6, column = 2)
					vol_check_button.deselect()
				else:
					vol_error.grid_forget()
					vol_check_button.select()
			except ValueError:
					vol_error.grid(row = 6, column = 2)
					vol_check_button.deselect()
						
			#pump check
			try:
				if pumpA.get() or pumpB.get() or pumpC.get() or pumpD.get():
					pump_error.grid_forget()
					pump_check_button.select()
				else:
					pump_error.grid(row = 2, column = 2)
					pump_check_button.deselect()
			except ValueError:
					pump_error.grid(row = 2, column = 2)
					pump_check_button.deselect()
						
			#reactor check
			try:
				if reactorA.get() == 1:
					if 20 <= float(reactor1_temp.get()) <= 150:
						reactor1_error.grid_forget()
						reactor1_button.select()
					else:
						reactor1_error.grid(row = 7, column = 4)
						reactor1_button.deselect()
				else:
					reactor1_button.select()
			except ValueError:
					reactor1_error.grid(row = 7, column = 4)
					reactor1_button.deselect()
						
			try:
				if reactorB.get() == 1:
					if 20 <= float(reactor2_temp.get()) <= 150:
						reactor2_error.grid_forget()
						reactor2_button.select()
					else:
						reactor2_error.grid(row = 8, column = 4)
						reactor2_button.deselect()
				else:
					reactor2_button.select()
			except ValueError:
					reactor2_error.grid(row = 8, column = 4)
					reactor2_button.deselect()
				
			try:
				if reactorC.get() == 1:
					if 20 <= float(reactor3_temp.get()) <= 150:
						reactor3_error.grid_forget()
						reactor3_button.select()
					else:
						reactor3_error.grid(row = 9, column = 4)
						reactor3_button.deselect()
				else:
					reactor3_button.select()
			except ValueError:
					reactor3_error.grid(row = 9, column = 4)
					reactor3_button.deselect()
						
			try:
				if reactorD.get() == 1:
					if 20 <= float(reactor4_temp.get()) <= 250:
						reactor4_error.grid_forget()
						reactor4_button.select()
					else:
						reactor4_error.grid(row = 10, column = 4)
						reactor4_button.deselect()
				else:
					reactor4_button.select()
			except ValueError:
					reactor4_error.grid(row = 10, column = 4)
					reactor4_button.deselect()
						
						
			run_check()
			
		def run_check():
			print("running run_check")
			print("min: %s" %min_check.get())
			print("max: %s" %max_check.get())
			print("vol: %s" %vol_check.get())
			print("PumpA: %s" %pumpA.get())
			print("PumpB: %s" %pumpB.get())
			print("PumpC: %s" %pumpC.get())
			print("PumpD: %s" %pumpD.get())
			print("Reactor 1: %s" %reactorA.get())
			print("Reactor 2: %s" %reactorB.get())
			print("Reactor 3: %s" %reactorC.get())
			print("Reactor 4: %s" %reactorD.get())
				
			if min_check.get() and max_check.get() and vol_check.get() and pump_check.get() and reactorA_check.get() and reactorB_check.get() and reactorC_check.get() and reactorD_check.get() == 1:
				run_button.configure(state = 'normal')
			else:
				run_button.configure(state = 'disabled')
					
		def run_test():
			check_input()
			if min_check.get() and max_check.get() and vol_check.get() and pump_check.get() and reactorA_check.get() and reactorB_check.get() and reactorC_check.get() and reactorD_check.get() == 1:
				Vport = str(port_.get())
				minflow = int(min_flow.get())
				maxflow = int(max_flow.get())
				volume = int(vol_.get())
				n = 0
				temp1 = str(reactor1_temp.get())
				temp2 = str(reactor2_temp.get())
				temp3 = str(reactor3_temp.get())
				temp4 = str(reactor4_temp.get())
					
				pump = str(pumpA.get()) + '.' + str(pumpB.get()) + '.' + str(pumpC.get()) + '.' + str(pumpD.get())
				react = str(reactorA.get()) + '.' + str(reactorB.get()) + '.' + str(reactorC.get()) + '.' + str(reactorD.get())
				
			
				VapourtecStart(Vport, minflow, maxflow, volume, pump, react, temp1, temp2, temp3, temp4, q1, q2, q3 ,q4)
					
			else:
				print("Error found in inputs")
					


		#variables
		vcmd = (master1.register(self.validate), '%i','%S',)
		vcmd2 = (master1.register(self.validate2), '%i','%S',)
		pumpA = IntVar()
		pumpB = IntVar()
		pumpC = IntVar()
		pumpD = IntVar()
		pump_check = IntVar()
		reactorA = IntVar()
		reactorA_check = IntVar()
		reactorB = IntVar()
		reactorB_check = IntVar()
		reactorC = IntVar()
		reactorC_check = IntVar()
		reactorD = IntVar()
		reactorD_check = IntVar()
		min_flow = StringVar()
		max_flow = StringVar()
		min_check = IntVar()
		max_check = IntVar()
		vol_ = IntVar()
		vol_check = IntVar()
		port_ = IntVar()
		
			
		#minimum flow
		minimum_flow_entry = Entry(root, textvariable = min_flow, validate = 'key', validatecommand = vcmd)
		minimum_flow_entry.grid(row = 0, column = 1)
		Label(master1, text = "Minimum total flow:").grid(row = 0, column = 0)
		min_flow_error = Label(master1, text = "Flow rate must be between 0.1 and 9.99 mL/min")
		min_flow_error.grid(row = 0, column = 2)
		min_check_button = Checkbutton(root, variable = min_check)
			
			
		#maximum flow
		maximum_flow_entry = Entry(root, textvariable = max_flow, validate = 'key', validatecommand = vcmd)
		maximum_flow_entry.grid(row = 1, column = 1)
		Label(master1, text = "Maximum total flow:").grid(row = 1, column = 0)
		max_flow_error = Label(master1, text = "Flow rate must be between 0.1 and 9.99 mL/min")
		max_flow_error.grid(row = 1, column = 2)
		max_check_button = Checkbutton(root, variable = max_check)
			
		#pumps
		Label(master1, text = "Pumps in use:").grid(row = 2, column = 0)
		pumpA_checkbox = Checkbutton(root, text="A", variable=pumpA)
		pumpB_checkbox = Checkbutton(root, text="B", variable=pumpB)
		pumpC_checkbox = Checkbutton(root, text="C", variable=pumpC)
		pumpD_checkbox = Checkbutton(root, text="D", variable=pumpD)
		pumpA_checkbox.grid(row = 2, column = 1)
		pumpB_checkbox.grid(row = 3, column = 1)
		pumpC_checkbox.grid(row = 4, column = 1)
		pumpD_checkbox.grid(row = 5, column = 1)
		pump_check_button = Checkbutton(root, variable = pump_check)
		pump_error = Label(root, text = "At least one pump must be selected.")
		pump_error.grid(row = 2, column = 2)
			
		#reactor volume
		Label(master1, text = "Reactor volume:").grid(row = 6, column = 0)
		reactor_volume_entry = Entry(root, textvariable = vol_, validate = 'key', validatecommand = vcmd)
		reactor_volume_entry.grid(row = 6, column = 1)
		vol_check_button = Checkbutton(root, variable = vol_check)
		vol_error = Label(master1, text = "Volume must be above 0 mL")
		vol_error.grid(row = 6, column = 2)
			
		#heated reactors
		Label(master1, text = "Heated reactors in use:").grid(row = 7, column = 0)
		reactor1 = Checkbutton(root, text="1", variable=reactorA, command = react_1_check)
		reactor2 = Checkbutton(root, text="2", variable=reactorB, command = react_2_check)
		reactor3 = Checkbutton(root, text="3", variable=reactorC, command = react_3_check)
		reactor4 = Checkbutton(root, text="4", variable=reactorD, command = react_4_check)
		reactor1_label = Label(master1, text = "Temperature:", state = 'disabled')
		reactor2_label = Label(master1, text = "Temperature:", state = 'disabled')
		reactor3_label = Label(master1, text = "Temperature:", state = 'disabled')
		reactor4_label = Label(master1, text = "Temperature:", state = 'disabled')
		reactor1_temp = Entry(root, state = 'disabled', validate = 'key', validatecommand = vcmd)
		reactor2_temp = Entry(root, state = 'disabled', validate = 'key', validatecommand = vcmd)
		reactor3_temp = Entry(root, state = 'disabled', validate = 'key', validatecommand = vcmd)
		reactor4_temp = Entry(root, state = 'disabled', validate = 'key', validatecommand = vcmd)
		reactor1_button = Checkbutton(root, variable = reactorA_check)
		reactor2_button = Checkbutton(root, variable = reactorB_check)
		reactor3_button = Checkbutton(root, variable = reactorC_check)
		reactor4_button = Checkbutton(root, variable = reactorD_check)
		reactor1_error = Label(root, text = "Reactor must be between 20 and 150 °C")
		reactor2_error = Label(root, text = "Reactor must be between 20 and 150 °C")
		reactor3_error = Label(root, text = "Reactor must be between 20 and 150 °C")
		reactor4_error = Label(root, text = "Reactor must be between 20 and 250 °C")
		reactor1.grid(row = 7, column = 1)
		reactor2.grid(row = 8, column = 1)
		reactor3.grid(row = 9, column = 1)
		reactor4.grid(row = 10, column = 1)
		reactor1_label.grid(row=7, column = 2)
		reactor2_label.grid(row=8, column = 2)
		reactor3_label.grid(row=9, column = 2)
		reactor4_label.grid(row=10, column = 2)
		reactor1_temp.grid(row = 7, column = 3)
		reactor2_temp.grid(row = 8, column = 3)
		reactor3_temp.grid(row = 9, column = 3)
		reactor4_temp.grid(row = 10, column = 3)
			
			
			
		#buttons
		port_entry = Entry(root, textvariable = port_, validate = 'key', validatecommand = vcmd2)
		port_entry.grid(row = 11, column = 1, stick = W)
		Label(master1, text = "Port:").grid(row = 11, column = 0)
		check_button = Button(root, text = "Check", width = 15, command = check_input)
		run_button = Button(root, text = "Run", width = 15, state = 'disabled', command = run_test)
		check_button.grid(row = 11, column = 2)
		run_button.grid(row = 11, column = 3, sticky = W)
							
	def validate(self, index, text):
		if text in '0123456789.' and index < "5":
			return True
		else:
			return False
		
	def validate2(self, index, text):
		if text in '0123456789' and index < "5":
			return True
		else:
			return False


if __name__ == '__main__':	
	
	run_q = multip.Queue()
	q1 = multip.Queue()
	q2 = multip.Queue()
	q3 = multip.Queue()
	q4 = multip.Queue()
	portq = multip.Queue()
			
	
	process2 = multip.Process(target=TempCheck, args=(run_q,q1,q2,q3,q4,portq))
	#process2.start()

	root = Tk()
	root.title("Automated push out method")
	window2(root)
	root.mainloop()
